<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('full_name', 'email', 'phone', 'is_smoking', 'active', 'latitude', 'longitude');

    public function rides()
    {
        return $this->hasMany('Ride');
    }

    public function wallet()
    {
        return $this->hasOne('Wallet');
    }

}